<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\Kategori;
use View;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $config = \DB::table('setings')->where('id',1)->first();
        $kategori = Kategori::all();
        $kategoriAcak = $kategori->shuffle()->take(4); // Ambil 4 data hasil pengacakan
        $dataAcak = $kategoriAcak->map(function ($item) {
            return [
                'nama' => $item->nama,
                'kode' => $item->kode,
            ];
        });
        
        View::share('config',$config);
        View::share('random',$dataAcak);
    }
}